-- Honor_Finisher
-- Author: Machiavelli
-- DateCreated: 5/29/2012 4:56:06 PM
--------------------------------------------------------------
function ScienceBoostOnCityCapture(hexPos, playerID, cityID, newPlayerID)
	local player = Players[newPlayerID];
	local policyID = GameInfoTypes["POLICY_HONOR_FINISHER"];

	-- Only run this if the player has the honor finisher policy 
	if (player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID)) then
		local team = Teams[player:GetTeam()];
		local teamTechs = team:GetTeamTechs();
		local currentTech = player:GetCurrentResearch();
		local researchProgress = teamTechs:GetResearchProgress(currentTech);

		local plot = Map.GetPlot(ToGridFromHex(hexPos.x, hexPos.y));
		local city = plot:GetPlotCity();

		-- Calculate the amount of bonus Science
		local currentEra = Players[playerID]:GetCurrentEra(); -- Era of the previous owner
		local population = city:GetPopulation();

		-- Formula for the bonus science
		local bonus = (population * (10 * (currentEra + 1)));

		-- Adjust the size of the bonus based on the game speed
		local speedResearchPercent = GameInfo.GameSpeeds[Game:GetGameSpeedType()].ResearchPercent;
		local adjustedBonus = (bonus * speedResearchPercent) / 100;

		-- Give the bonus science
		teamTechs:SetResearchProgress(currentTech, researchProgress + adjustedBonus);

		-- Send a notification to the player
		local text = Locale.ConvertTextKey("TXT_KEY_SCIENCE_FROM_CITY_CAPTURE", city:GetName(), tostring(adjustedBonus));
		player:AddNotification(NotificationTypes.NOTIFICATION_GENERIC, text, text);


		--local scienceYield = city:GetYieldRateTimes100(YieldTypes.YIELD_SCIENCE) / 100;
		-- Is always 0 due to resistance and science buildings are already gone.
	end
end
Events.SerialEventCityCaptured.Add(ScienceBoostOnCityCapture);